import os

class ProductionConfig:
    SECRET_KEY = os.environ.get('SECRET_KEY') or '744af7482494f60dcdc6abfab2effff2c72c071f906232abe52f67f3c12f675a'
    SQLALCHEMY_DATABASE_URI = os.environ.get('DATABASE_URL') or 'sqlite:///ai_dashboard_prod.db'
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    SERVER_NAME = 'ecoenterprise.online'
    SESSION_COOKIE_SECURE = True
    SESSION_COOKIE_HTTPONLY = True
    SESSION_COOKIE_SAMESITE = 'Lax'
    DEBUG = False
    TESTING = False

def configure_app(app):
    app.config.from_object(ProductionConfig)

    @app.after_request
    def add_security_headers(response):
        response.headers['X-Content-Type-Options'] = 'nosniff'
        response.headers['X-Frame-Options'] = 'DENY'
        response.headers['X-XSS-Protection'] = '1; mode=block'
        response.headers['Strict-Transport-Security'] = 'max-age=31536000; includeSubDomains'
        return response

    return app